/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.impl.modmenu;

import dev.tr7zw.trender.gui.client.LibGui;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.client.ScreenDrawing;
import dev.tr7zw.trender.gui.impl.LibGuiCommon;
import dev.tr7zw.trender.gui.widget.WWidget;
import java.util.ArrayList;
import net.minecraft.class_2960;

public class WKirbSprite
extends WWidget {
    private static final class_2960 KIRB = LibGuiCommon.id("textures/widget/kirb.png");
    private static final float PX = 0.0024038462f;
    private static final float KIRB_WIDTH = 0.07692308f;
    private int currentFrame = 0;
    private long currentFrameTime = 0L;
    private int[] toSleep = new int[]{0, 0, 0, 1, 2, 1, 2, 0, 0, 0, 1, 2, 3};
    private int[] asleep = new int[]{4, 4, 4, 4, 5, 6, 7, 6, 5};
    private int[] toAwake = new int[]{3, 3, 8, 8, 8, 8, 8, 8, 8};
    private int[] awake = new int[]{9, 9, 9, 10, 11, 12};
    private State state = State.ASLEEP;
    private ArrayList<Integer> pendingFrames = new ArrayList();
    private int frameTime = 300;
    private long lastFrame;

    public WKirbSprite() {
        this.state = LibGui.getGuiStyle().isDark() ? State.ASLEEP : State.AWAKE;
    }

    public void schedule(int[] frames) {
        for (int i : frames) {
            this.pendingFrames.add(i);
        }
    }

    @Override
    public boolean canResize() {
        return false;
    }

    @Override
    public int getWidth() {
        return 32;
    }

    @Override
    public int getHeight() {
        return 32;
    }

    @Override
    public void paint(RenderContext context, int x, int y, int mouseX, int mouseY) {
        long now = System.nanoTime() / 1000000L;
        if (this.pendingFrames.isEmpty()) {
            if (LibGui.getGuiStyle().isDark()) {
                this.state = switch (this.state.ordinal()) {
                    case 0 -> State.FALLING_ASLEEP;
                    case 1 -> State.ASLEEP;
                    default -> State.ASLEEP;
                };
            } else {
                this.state = switch (this.state.ordinal()) {
                    case 2 -> State.WAKING_UP;
                    case 3 -> State.AWAKE;
                    default -> State.AWAKE;
                };
            }
            switch (this.state.ordinal()) {
                case 2: {
                    this.schedule(this.asleep);
                    break;
                }
                case 3: {
                    this.schedule(this.toAwake);
                    break;
                }
                case 0: {
                    this.schedule(this.awake);
                    break;
                }
                case 1: {
                    this.schedule(this.toSleep);
                }
            }
        }
        float offset = 0.07692308f * (float)this.currentFrame;
        ScreenDrawing.texturedRect(context, x, y + 8, 32, 32, KIRB, offset, 0.0f, offset + 0.07692308f, 1.0f, -1, 416, 32);
        long elapsed = now - this.lastFrame;
        this.currentFrameTime += elapsed;
        if (this.currentFrameTime >= (long)this.frameTime) {
            if (!this.pendingFrames.isEmpty()) {
                this.currentFrame = this.pendingFrames.remove(0);
            }
            this.currentFrameTime = 0L;
        }
        this.lastFrame = now;
    }

    public static enum State {
        AWAKE,
        FALLING_ASLEEP,
        ASLEEP,
        WAKING_UP;

    }
}

